def parse_out_hashtag(s):
    """
    >>> parse_out_hashtag('You are so cool #amazing')
    ['amazing']
    >>> parse_out_hashtag('I love #cats #dogs #hamsters')
    ['cats', 'dogs', 'hamsters']
    >>> parse_out_hashtag('I do not like hashtags')
    []
    >>> parse_out_hashtag("So far, we've covered #strings #lists #bit #functions")
    ['strings', 'lists', 'bit', 'functions']
    >>> parse_out_hashtag("#QueenB is amazing :) #RenaissanceTour")
    ['QueenB', 'RenaissanceTour']
    """

    start_search_indx = 0
    hashtag_lst = []
    while True:
        octothorpe_loc = s.find('#', start_search_indx)
        # out of hashtags, so stop searching
        if octothorpe_loc == -1:
            break

        end = octothorpe_loc + 1
        while end < len(s) and s[end].isalnum():
            end += 1
        curr_hashtag = s[octothorpe_loc + 1:end]

        # only add a hashtag that isn't an empty string
        if curr_hashtag != '':
            hashtag_lst.append(curr_hashtag)

        start_search_indx = end  # the next character might be a hashtag

    return hashtag_lst
